/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.model.Animator;
import com.lycanitesmobs.client.model.IAnimationModel;
import com.lycanitesmobs.client.model.ModelAnimation;
import com.lycanitesmobs.client.model.ModelCustom;
import com.lycanitesmobs.client.model.ModelObjAnimationFrame;
import com.lycanitesmobs.client.model.ModelObjPart;
import com.lycanitesmobs.client.model.ModelObjState;
import com.lycanitesmobs.client.obj.ObjObject;
import com.lycanitesmobs.client.obj.TessellatorModel;
import com.lycanitesmobs.client.obj.VBOModel;
import com.lycanitesmobs.client.renderer.RenderCreature;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureBase;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ModInfo;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

@SideOnly(value=Side.CLIENT)
public class ModelCreatureObj
extends ModelCustom
implements IAnimationModel {
    public static float modelXRotOffset = 180.0f;
    public static float modelYPosOffset = -1.5f;
    public TessellatorModel wavefrontObject;
    public List<ObjObject> wavefrontParts;
    public Map<String, ModelObjPart> animationParts = new HashMap<String, ModelObjPart>();
    public float lookHeadScaleX = 1.0f;
    public float lookHeadScaleY = 1.0f;
    public float lookNeckScaleX = 0.0f;
    public float lookNeckScaleY = 0.0f;
    public float lookBodyScaleX = 0.0f;
    public float lookBodyScaleY = 0.0f;
    public boolean bigChildHead = false;
    public boolean bodyIsTrophy = true;
    public float trophyScale = 1.0f;
    public float[] trophyOffset = new float[0];
    public float[] trophyMouthOffset = new float[0];
    public boolean dontColor = false;
    protected Animator animator;
    protected ModelObjPart currentAnimationPart;
    protected ModelAnimation animation;
    private final Map<Entity, ModelObjState> modelStates = new WeakHashMap<Entity, ModelObjState>();
    protected ModelObjState currentModelState;

    public ModelCreatureObj() {
        this(1.0f);
    }

    public ModelCreatureObj(float shadowSize) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelCreatureObj initModel(String name, ModInfo groupInfo, String path) {
        CreatureInfo creatureInfo = CreatureManager.getInstance().getCreature(name);
        if (creatureInfo != null && !creatureInfo.enabled) {
            return this;
        }
        this.wavefrontObject = new VBOModel(new ResourceLocation(groupInfo.modid, "models/" + path + ".obj"));
        this.wavefrontParts = this.wavefrontObject.objObjects;
        if (this.wavefrontParts.isEmpty()) {
            LycanitesMobs.logWarning("", "Unable to load any parts for the " + name + " model!");
        }
        this.animator = new Animator();
        ResourceLocation modelPartsLocation = new ResourceLocation(groupInfo.modid, "models/" + path + "_parts.json");
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            InputStream in = Minecraft.func_71410_x().func_110442_L().func_110536_a(modelPartsLocation).func_110527_b();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            try {
                JsonArray jsonArray = (JsonArray)JsonUtils.func_193839_a((Gson)gson, (Reader)reader, JsonArray.class);
                Iterator jsonIterator = jsonArray.iterator();
                while (jsonIterator.hasNext()) {
                    JsonObject partJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                    ModelObjPart animationPart = new ModelObjPart();
                    animationPart.loadFromJson(partJson);
                    this.addAnimationPart(animationPart);
                }
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "There was a problem loading animation parts for " + name + ":");
            e.printStackTrace();
        }
        for (ModelObjPart part : this.animationParts.values()) {
            part.addChildren(this.animationParts.values().toArray(new ModelObjPart[this.animationParts.size()]));
        }
        ResourceLocation animationLocation = new ResourceLocation(groupInfo.modid, "models/" + path + "_animation.json");
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            InputStream in = Minecraft.func_71410_x().func_110442_L().func_110536_a(animationLocation).func_110527_b();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            try {
                JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)gson, (Reader)reader, JsonObject.class);
                this.animation = new ModelAnimation();
                this.animation.loadFromJson(json);
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("Models", "Unable to load animation json for " + name + ".");
        }
        return this;
    }

    public void addAnimationPart(ModelObjPart animationPart) {
        if (this.animationParts.containsKey(animationPart.name)) {
            return;
        }
        if (animationPart.parentName != null && animationPart.parentName.equals(animationPart.name)) {
            animationPart.parentName = null;
        }
        this.animationParts.put(animationPart.name, animationPart);
    }

    @Override
    public void addCustomLayers(RenderCreature renderer) {
        super.addCustomLayers(renderer);
        if (this.animation != null) {
            this.animation.addCreatureLayers(renderer);
        }
    }

    @Override
    public void render(Entity entity, float time, float distance, float loop, float lookY, float lookX, float scale, LayerCreatureBase layer, boolean animate) {
        boolean renderAsTrophy = false;
        if (scale < 0.0f) {
            renderAsTrophy = true;
            scale = -scale;
        } else if (entity instanceof BaseCreatureEntity) {
            scale *= 16.0f;
            scale = (float)((double)scale * ((BaseCreatureEntity)entity).getRenderScale());
        } else if (entity instanceof BaseProjectileEntity) {
            scale *= 4.0f;
            scale *= ((BaseProjectileEntity)entity).getProjectileScale();
        }
        if (entity instanceof BaseCreatureEntity) {
            BaseCreatureEntity creature = (BaseCreatureEntity)entity;
            if (creature.onlyRenderTicks >= 0.0f) {
                loop = creature.onlyRenderTicks;
            }
        }
        this.currentModelState = this.getModelState(entity);
        if (layer == null) {
            this.updateAttackProgress(entity);
        }
        if (animate) {
            if (entity instanceof BaseCreatureEntity && ((BaseCreatureEntity)entity).hasPerchTarget()) {
                distance = 0.0f;
            }
            this.generateAnimationFrames(entity, time, distance, loop, lookY, lookX, scale, layer, renderAsTrophy);
        }
        for (ObjObject part : this.wavefrontParts) {
            String partName = part.getName().toLowerCase();
            if (!this.canRenderPart(partName, entity, layer, renderAsTrophy)) continue;
            this.currentAnimationPart = this.animationParts.get(partName);
            if (this.currentAnimationPart == null) continue;
            GlStateManager.func_179094_E();
            this.animator.doAngle(modelXRotOffset, 1.0f, 0.0f, 0.0f);
            this.animator.doTranslate(0.0f, modelYPosOffset, 0.0f);
            if (this.field_78091_s && !renderAsTrophy) {
                this.childScale(partName);
                if (this.bigChildHead && (partName.contains("head") || partName.contains("mouth"))) {
                    this.animator.doTranslate(-(this.currentAnimationPart.centerX / 2.0f), -(this.currentAnimationPart.centerY / 2.0f), -(this.currentAnimationPart.centerZ / 2.0f));
                }
            }
            if (renderAsTrophy) {
                this.animator.doScale(this.trophyScale, this.trophyScale, this.trophyScale);
            }
            this.animator.doScale(scale, scale, scale);
            this.currentAnimationPart.applyAnimationFrames(this.animator);
            this.onRenderStart(layer, entity, renderAsTrophy);
            this.wavefrontObject.renderGroup(part, this.getPartColor(partName, entity, layer, renderAsTrophy, loop), this.getPartTextureOffset(partName, entity, layer, renderAsTrophy, loop), null);
            this.onRenderFinish(layer, entity, renderAsTrophy);
            GlStateManager.func_179121_F();
        }
        if (animate) {
            this.clearAnimationFrames();
        }
        this.currentModelState = null;
    }

    public void onRenderStart(LayerCreatureBase layer, Entity entity, boolean renderAsTrophy) {
        if (!CreatureManager.getInstance().config.disableModelAlpha) {
            GlStateManager.func_179147_l();
        }
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        if (layer != null) {
            layer.onRenderStart(entity, renderAsTrophy);
        }
    }

    public void onRenderFinish(LayerCreatureBase layer, Entity entity, boolean renderAsTrophy) {
        if (!CreatureManager.getInstance().config.disableModelAlpha) {
            GlStateManager.func_179084_k();
        }
        if (layer != null) {
            layer.onRenderFinish(entity, renderAsTrophy);
        }
    }

    public void generateAnimationFrames(Entity entity, float time, float distance, float loop, float lookY, float lookX, float scale, LayerCreatureBase layer, boolean renderAsTrophy) {
        for (ObjObject part : this.wavefrontParts) {
            String partName = part.getName().toLowerCase();
            this.currentAnimationPart = this.animationParts.get(partName);
            if (this.currentAnimationPart == null) continue;
            if (entity instanceof EntityLiving) {
                this.animatePart(partName, (EntityLiving)entity, time, distance, loop, -lookY, lookX, scale);
            }
            if (!renderAsTrophy) continue;
            if (partName.contains("head")) {
                if (!partName.contains("left")) {
                    this.translate(-0.3f, 0.0f, 0.0f);
                    this.angle(5.0f, 0.0f, 1.0f, 0.0f);
                }
                if (!partName.contains("right")) {
                    this.translate(0.3f, 0.0f, 0.0f);
                    this.angle(-5.0f, 0.0f, 1.0f, 0.0f);
                }
            }
            if (this.trophyOffset.length < 3) continue;
            this.translate(this.trophyOffset[0], this.trophyOffset[1], this.trophyOffset[2]);
        }
    }

    public void clearAnimationFrames() {
        for (ModelObjPart animationPart : this.animationParts.values()) {
            animationPart.animationFrames.clear();
        }
    }

    @Override
    public boolean canRenderPart(String partName, Entity entity, LayerCreatureBase layer, boolean trophy) {
        if (partName == null) {
            return false;
        }
        if (!this.animationParts.containsKey(partName = partName.toLowerCase())) {
            return false;
        }
        if (trophy && !this.isTrophyPart(partName)) {
            return false;
        }
        return super.canRenderPart(partName, entity, layer, trophy);
    }

    public boolean isTrophyPart(String partName) {
        if (partName == null) {
            return false;
        }
        if ((partName = partName.toLowerCase()).contains("head") || partName.contains("mouth") || partName.contains("eye")) {
            return true;
        }
        return this.bodyIsTrophy && partName.contains("body");
    }

    public void animatePart(String partName, EntityLiving entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        if (partName.equals("head")) {
            rotX = (float)((double)rotX + Math.toDegrees(lookX / 57.295776f) * (double)this.lookHeadScaleX);
            rotY = (float)((double)rotY + Math.toDegrees(lookY / 57.295776f) * (double)this.lookHeadScaleY);
        }
        if (partName.contains("neck")) {
            rotX = (float)((double)rotX + Math.toDegrees(lookX / 57.295776f) * (double)this.lookNeckScaleX);
            rotY = (float)((double)rotY + Math.toDegrees(lookY / 57.295776f) * (double)this.lookNeckScaleY);
        }
        this.rotate(rotX, rotY, rotZ);
    }

    public ModelObjState getModelState(Entity entity) {
        if (entity == null) {
            return null;
        }
        return this.modelStates.computeIfAbsent(entity, k -> new ModelObjState());
    }

    public void childScale(String partName) {
        if (this.bigChildHead && (partName.contains("head") || partName.contains("mouth"))) {
            return;
        }
        this.animator.doScale(0.5f, 0.5f, 0.5f);
    }

    public void updateAttackProgress(Entity entity) {
        if (this.currentModelState == null || !(entity instanceof BaseCreatureEntity)) {
            return;
        }
        BaseCreatureEntity entityCreature = (BaseCreatureEntity)entity;
        if (this.currentModelState.attackAnimationPlaying) {
            if (this.currentModelState.attackAnimationIncreasing) {
                this.currentModelState.attackAnimationProgress = Math.min(this.currentModelState.attackAnimationProgress + this.currentModelState.attackAnimationSpeed, 1.0f);
                if (this.currentModelState.attackAnimationProgress >= 1.0f) {
                    this.currentModelState.attackAnimationIncreasing = false;
                }
            } else {
                this.currentModelState.attackAnimationProgress = Math.max(this.currentModelState.attackAnimationProgress - this.currentModelState.attackAnimationSpeed, 0.0f);
                if (this.currentModelState.attackAnimationProgress <= 0.0f) {
                    this.currentModelState.attackAnimationPlaying = false;
                }
            }
        } else if (entityCreature.isAttackOnCooldown()) {
            this.currentModelState.attackAnimationPlaying = true;
            this.currentModelState.attackAnimationIncreasing = true;
            this.currentModelState.attackAnimationProgress = 0.0f;
        }
    }

    public float getAttackProgress() {
        if (this.currentModelState == null) {
            return 0.0f;
        }
        return this.currentModelState.attackAnimationProgress;
    }

    @Override
    public void angle(float rotation, float angleX, float angleY, float angleZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("angle", rotation, angleX, angleY, angleZ));
    }

    @Override
    public void rotate(float rotX, float rotY, float rotZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("rotate", 1.0f, rotX, rotY, rotZ));
    }

    @Override
    public void translate(float posX, float posY, float posZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("translate", 1.0f, posX, posY, posZ));
    }

    @Override
    public void scale(float scaleX, float scaleY, float scaleZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("scale", 1.0f, scaleX, scaleY, scaleZ));
    }

    @Override
    public double rotateToPoint(double aTarget, double bTarget) {
        return this.rotateToPoint(0.0, 0.0, aTarget, bTarget);
    }

    @Override
    public double rotateToPoint(double aCenter, double bCenter, double aTarget, double bTarget) {
        if (aTarget - aCenter == 0.0) {
            if (aTarget > aCenter) {
                return 0.0;
            }
            if (aTarget < aCenter) {
                return 180.0;
            }
        }
        if (bTarget - bCenter == 0.0) {
            if (bTarget > bCenter) {
                return 90.0;
            }
            if (bTarget < bCenter) {
                return -90.0;
            }
        }
        if (aTarget - aCenter == 0.0 && bTarget - bCenter == 0.0) {
            return 0.0;
        }
        return Math.toDegrees(Math.atan2(aCenter - aTarget, bCenter - bTarget) - 1.5707963267948966);
    }

    @Override
    public double[] rotateToPoint(double xCenter, double yCenter, double zCenter, double xTarget, double yTarget, double zTarget) {
        double[] rotations = new double[]{this.rotateToPoint(yCenter, -zCenter, yTarget, -zTarget), this.rotateToPoint(-zCenter, xCenter, -zTarget, xTarget), this.rotateToPoint(yCenter, xCenter, yTarget, xTarget)};
        return rotations;
    }

    public void shiftOrigin(String fromPartName, String toPartName) {
        ModelObjPart fromPart = this.animationParts.get(fromPartName);
        ModelObjPart toPart = this.animationParts.get(toPartName);
        float offsetX = toPart.centerX - fromPart.centerX;
        float offsetY = toPart.centerY - fromPart.centerY;
        float offsetZ = toPart.centerZ - fromPart.centerZ;
        this.translate(offsetX, offsetY, offsetZ);
    }

    public void shiftOriginBack(String fromPartName, String toPartName) {
        ModelObjPart fromPart = this.animationParts.get(fromPartName);
        ModelObjPart toPart = this.animationParts.get(toPartName);
        float offsetX = toPart.centerX - fromPart.centerX;
        float offsetY = toPart.centerY - fromPart.centerY;
        float offsetZ = toPart.centerZ - fromPart.centerZ;
        this.translate(-offsetX, -offsetY, -offsetZ);
    }
}

